﻿//"""MLBERTMGR API CSharp wrapper."""
//__version__     = "1.7.3"
//__author__      = "MultilaneInc <support@multilaneinc.com>"
//__date__        = '2025-10-09'

using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using System.ComponentModel;
using System.IO;


namespace MLBERT
{

    #region EnumsandStructs
    public enum BERTMGR_STATUS
    {
        BERTMGR_SUCCESS = 0,                // Operation successful
        BERTMGR_FAILED = 1,                 // Operation failed
        BERTMGR_TIMEOUT = 2,                // Operation timed out
        BERTMGR_NOT_CONNECTED = 3,          // Device not connected
        BERTMGR_INVALID_INPUT = 4,          // Invalid input provided
        BERTMGR_INVALID_INSTANCE = 5,       // Invalid instance provided to API call
        BERTMGR_INVALID_CALIBRATION = 6,    // Invalid calibration
        BERTMGR_INCOMPATIBLE_CONFIG = 7,    // Operation not compatible with current configuration
        BERTMGR_UNSUPPORTED_OPTION = 8,     // Option not supported for the current board
        BERTMGR_CLOCK_FAILED = 9,           // Clock failed
        BERTMGR_BER_DISABLED = 10,          // BER disabled
        BERTMGR_BER_ENABLED = 11			// BER enabled
    }

    public enum BERTMGR_SIGMODULATION
    {
        BERTMGR_PAM4 = 0,
        BERTMGR_NRZ = 1
    };

    public enum BERTMGR_PATTERNTYPE
    {
        BERTMGR_PRBS7 = 0,
        BERTMGR_PRBS9_4 = 1,
        BERTMGR_PRBS9_5 = 2,
        BERTMGR_PRBS11 = 3,
        BERTMGR_PRBS13 = 4,
        BERTMGR_PRBS15 = 5,
        BERTMGR_PRBS16 = 6,
        BERTMGR_PRBS23 = 7,
        BERTMGR_PRBS31 = 8,
        BERTMGR_PRBS58 = 9,
        BERTMGR_USERDEFINED = 10,
        BERTMGR_JP03B = 11,
        BERTMGR_LIN = 12,
        BERTMGR_CJT = 13,
        BERTMGR_SSPRQ = 14,
        BERTMGR_SQ16 = 15,
        BERTMGR_SQ32 = 16,
        BERTMGR_IEEE8023BS_2 = 17,
        BERTMGR_IEEE8023BS_4 = 18,
        BERTMGR_OIFCEI311 = 19,
    };

    public enum BERTMGR_CLOCKSOURCE
    {
        BERTMGR_EXTERNALCLKSRC = 0,
        BERTMGR_INTERNALCLKSRC = 1
    };

    public enum BERTMGR_CLOCKMODE
    {
        BERTMGR_MONITORCLOCK_CH0toCH3 = 0,
        BERTMGR_EXTERNAL = 1,
        BERTMGR_REFCLK = 2,
        BERTMGR_MONITORCLOCK_CH4toCH7 = 3,
        BERTMGR_CDR_CH0toCH3 = 4,
        BERTMGR_CDR_CH4toCH7 = 5,
        BERTMGR_REFCLK2 = 6
    };

    public enum BERTMGR_MONITOR_FLAGS
    {
        BERTMGR_MONITOR_LOS = 0x1 << 0,             // LOS Enable Flag (bit 0)
        BERTMGR_MONITOR_DSP = 0x1 << 1,             // DSP Monitor Enable Flag (bit 1)
        BERTMGR_MONITOR_SIGNALDETECT = 0x1 << 2,    // Signal Detect Monitor Flag (bit 2)
        BERTMGR_MONITOR_TXLOCK = 0x1 << 3,          // Tx Lock Monitor Flag (bit 3)
        BERTMGR_MONITOR_RXLOCK = 0x1 << 4,          // RX Lock Monitor Flag (bit 4)
        BERTMGR_MONITOR_TEMPERATURE = 0x1 << 5,     // Temperature Monitor Flag (bit 5)
        BERTMGR_MONITOR_SNR = 0x1 << 6,             // SNR Monitor Flag (bit 6), 10*SNR Monitoring value 
        BERTMGR_MONITOR_VOLTAGE = 0x1 << 7,         // Voltage Monitor Flag (bit 7)
        BERTMGR_MONITOR_CURRENT = 0x1 << 8,         // Current Monitor Flag (bit 8)
        BERTMGR_MONITOR_FFETAPS = 0x1 << 9,         // FFE Taps Monitor Flag (bit 9)
        // ml4054
        BERTMGR_MONITOR_XT_TXLOCK = 0x1 << 10,
        BERTMGR_MONITOR_ADAPTER = 0x1 << 11,
        BERTMGR_MONITOR_TRANSCEIVER = 0x1 << 12
    };

    public enum BERTMGR_ERRORINSERTIONMODES
    {
        BERTMGR_ERRINJ_PAT_BIT0,    // bit 0 one MSB
        BERTMGR_ERRINJ_PAT_BIT1,    // bit 1 one LSB
        BERTMGR_ERRINJ_PAT_BIT01,   // bit 0 and 1 one PAM4 (MSB and LSB)
        BERTMGR_ERRINJ_PAT_MSBS,    // all MSBs
        BERTMGR_ERRINJ_PAT_LSBS,    // all LSBs
        BERTMGR_ERRINJ_PAT_ALL      // all bits
    };

    [StructLayout(LayoutKind.Sequential)]
    public struct ErrorStruct
    {
        [MarshalAs(UnmanagedType.I4)]
        public BERTMGR_ERRORINSERTIONMODES pattern;
        [MarshalAs(UnmanagedType.U1)]
        public byte gap;
        [MarshalAs(UnmanagedType.U1)]
        public byte duration;
    };

    public enum BERTMGR_FECMODE
    {
        BERTMGR_FECDISABLED = -1,
        BERTMGR_400G_KP8_TO_KP4 = 0,
        BERTMGR_200G_KP4_TO_KP2 = 1,
        BERTMGR_200G_KP4_TO_KP4 = 2,
        BERTMGR_100G_KP2_TO_KP1 = 3,
        BERTMGR_100G_KP4_TO_KP4 = 4,
        BERTMGR_100G_KP4_TO_KP2 = 5,
        BERTMGR_100G_PCS4_TO_KR1 = 6,
        BERTMGR_50G_KP1_TO_KP1 = 7,
        BERTMGR_50G_KP2_TO_KP2 = 8,
        BERTMGR_50G_KR2_TO_KR1 = 9,
        BERTMGR_25G_KR1_TO_KR1 = 10,
        BERTMGR_25G_KP1_TO_KP1 = 11,
        BERTMGR_50G_KS = 20,
        BERTMGR_50G_KR = 21,
        BERTMGR_50G_KP = 22,
        BERTMGR_100G_KR = 23,
        BERTMGR_100G_KP = 24,
        BERTMGR_200G_KP = 25,
        BERTMGR_400G_KP = 26,
        //  ML4054B FEC Modes
        BERTMGR_25G_FC = 40,
        BERTMGR_25G_KR4 = 41,
        BERTMGR_25G_KP4 = 42,
        BERTMGR_50G_FC = 43,
        BERTMGR_50G_KR4 = 44,
        BERTMGR_50G_KP4 = 45,
        BERTMGR_100G_FC = 46,
        BERTMGR_100G_KR4 = 47,
        BERTMGR_100G_KP4 = 48,
        BERTMGR_200G_FC = 49,
        BERTMGR_200G_KR4 = 50,
        BERTMGR_200G_KP4 = 51
    };

    //Struct and enus for host module
    public enum BERTMGR_FECPATTERN
    {
        BERTMGR_FECPATTERN_DISABLED = -1,
        BERTMGR_FECPATTERN_IDLE = 0,
        BERTMGR_FECPATTERN_LOCALFAULT = 1,
        BERTMGR_FECPATTERN_REMOTEFAULT = 2
    };


    public enum BERTMGR_CALIBRATIONMODE
    {
        BERTMGR_CALMODE_ADV = -1,   // Advanced mode
        BERTMGR_CALMODE_LRLV = 0,   // Low-rate/low-voltage
        BERTMGR_CALMODE_LRHV = 1,   // Low-rate/high-voltage
        BERTMGR_CALMODE_HRLV = 2,   // High-rate/low-voltage
        BERTMGR_CALMODE_HRHV = 3,   // High-rate/high-voltage
    };


    public enum BERTMGR_MONITORDIVIDER
    {
        BERTMGR_MONITOR_DIV1 = 1 << 0,
        BERTMGR_MONITOR_DIV4 = 1 << 2,
        BERTMGR_MONITOR_DIV8 = 1 << 3,
        BERTMGR_MONITOR_DIV16 = 1 << 4,
        BERTMGR_MONITOR_DIV32 = 1 << 5,
        BERTMGR_MONITOR_DIV64 = 1 << 6,
        BERTMGR_MONITOR_DIV128 = 1 << 7
    };


    public enum BERTMGR_CDRDIVIDER
    {
        BERTMGR_CDR_DIV32 = 1 << 5,
        BERTMGR_CDR_DIV64 = 1 << 6,
        BERTMGR_CDR_DIV128 = 1 << 7,
        BERTMGR_CDR_DIV256 = 1 << 8,
        BERTMGR_CDR_DIV512 = 1 << 9,
        BERTMGR_CDR_DIV1024 = 1 << 10,
        BERTMGR_CDR_DIV2048 = 1 << 11,
        BERTMGR_CDR_DIV4096 = 1 << 12,
    };



    [StructLayout(LayoutKind.Sequential)]
    public struct PatternConfig
    {
        [MarshalAs(UnmanagedType.I4)]
        public BERTMGR_PATTERNTYPE pattern;
        [MarshalAs(UnmanagedType.I1)]
        public bool invert;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 2)]
        public ulong[] userDefined;
        [MarshalAs(UnmanagedType.I4)]
        public int repetition;
    };


    [StructLayout(LayoutKind.Sequential)]
    public struct Board_Info
    {
        [MarshalAs(UnmanagedType.U2)]
        public ushort boardID;
        [MarshalAs(UnmanagedType.U2)]
        public ushort HWRev;
        [MarshalAs(UnmanagedType.U2)]
        public ushort FWRev;
        [MarshalAs(UnmanagedType.U2)]
        public ushort SilabRev;
        [MarshalAs(UnmanagedType.U4)]
        public uint ipAddress;
        [MarshalAs(UnmanagedType.U4)]
        public uint Mask;
        [MarshalAs(UnmanagedType.U4)]
        public uint Gateway;
        [MarshalAs(UnmanagedType.U8)]
        public ulong MAC;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 10)]
        public byte[] SN;
        [MarshalAs(UnmanagedType.I1)]
        public bool Bootloader_Flag;//check last code
        [MarshalAs(UnmanagedType.I1)]
        public bool isAdapterMode;
        [MarshalAs(UnmanagedType.I4)]
        public ADAPTER_TYPE adapterType;
    };

    public struct SERData
    {
        [MarshalAs(UnmanagedType.I4)]
        public int nSymbols;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 31)]
        public uint[] InstantSER;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 31)]
        public ulong[] AccumulatedSER;
    };

    public struct BERData
    {
        [MarshalAs(UnmanagedType.I1)]
        public bool IsEnabled;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] enabledChannels;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] lockedChannels;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] Time;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] BitCount;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] ErrorCount_MSB;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] ErrorCount_LSB;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] ErrorCount;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedErrorCount_MSB;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] BER_MSB_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] BER_MSB_Realtime;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedErrorCount_LSB;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] BER_LSB_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] BER_LSB_Realtime;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedErrorCount;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] BER_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] BER_Realtime;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] TotalBitCount;
    }

    /// <summary>
    /// Struct for real FEC link measurements
    /// </summary>
    public struct RealFECData
    {
        [MarshalAs(UnmanagedType.I1)]
        public bool IsEnabled;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] enabledChannels;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] lockedChannels;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] Time;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] BitCount;
        //  TODO    25-02-2020  Review data size
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] FEC_Skew;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] FEC_Corrected_Ones_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] FEC_Corrected_Zeros_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] FEC_ErrorCount_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] FEC_Symbol_ErrorCount_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] FEC_CorrectedBitCount_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] FEC_Symbol_ErrorRate_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] FEC_CorrectedBitRate_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] FEC_Frame_ErrorRate_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] FEC_CW_UnCorrectedCount_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] FEC_CW_CorrectedCount_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] FEC_CW_ProcessedCount_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] FEC_CW_UncorrectedErrorRate_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedFEC_Corrected_Ones;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedFEC_Corrected_Zeros;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedFEC_ErrorCount;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedFEC_Symbol_ErrorCount;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedFEC_CorrectedBitCount;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] AveragedFEC_Symbol_ErrorRate;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] AveragedFEC_CorrectedBitRate;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] AveragedFEC_Frame_ErrorRate;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedFEC_CW_UnCorrectedCount;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedFEC_CW_CorrectedCount;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedFEC_CW_ProcessedCount;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] AccumulatedFEC_CW_UncorrectedErrorRate;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public SERData[] SER;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] TotalBitCount;
    }

    /// <summary>
    /// Parsed emulator FEC link data
    /// </summary>
    public struct EmulatorFECData
    {
        [MarshalAs(UnmanagedType.I1)]
        public bool IsEnabled;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] enabledLinks;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] lockedLinks;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] FEC_CorrectedBitError;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] FEC_BlockCount;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] FEC_SaturatedSymbolError;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedFEC_CorrectedBitError;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedFEC_BlockCount;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedFEC_SaturatedSymbolError;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public SERData[] SER;
    };

    /// <summary>
    /// Struct for real FEC link measurements
    /// </summary>
    public struct VegaFECData
    {
        [MarshalAs(UnmanagedType.I1)]
        public bool IsEnabled;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] enabledChannels;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] lockedChannels;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] Time;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] BitCount;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] FEC_CorrectedBitCount_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] FEC_CW_UnCorrectedCount_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] FEC_CW_CorrectedCount_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 16)]
        public uint[] FEC_CW_ProcessedCount_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] FEC_CW_UncorrectedErrorRate_Interval;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedFEC_CW_UnCorrectedCount;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedFEC_CW_CorrectedCount;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] AccumulatedFEC_CW_ProcessedCount;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] AccumulatedFEC_CW_UncorrectedErrorRate;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public SERData[] SER;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U8, SizeConst = 16)]
        public ulong[] TotalBitCount;
    }

    public struct JtolData
    {
        [MarshalAs(UnmanagedType.I1)]
        public bool IsEnabled;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] enabledChannels;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] lockedChannels;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] Time;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] JtolVal;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] FMFrequencyVal;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] UIFrequencyVal;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] JtolMargin;

    }

    public struct ItolData
    {
        [MarshalAs(UnmanagedType.I1)]
        public bool IsEnabled;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] enabledChannels;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] lockedChannels;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] Time;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] ItolVal;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.R8, SizeConst = 16)]
        public double[] ItolMargin;
    }


    [StructLayout(LayoutKind.Sequential)]
    public struct MeasurementsData
    {
        public BERData berData;                  // BER measurements
        public RealFECData realFecData;          // Real FEC measurements
        public EmulatorFECData emulatorFecData;  // Emulator FEC measurements
        public VegaFECData vegaFecData;          // Vega FEC measurements
        public JtolData jtolData;
        public ItolData itolData;
    };

    public enum BERTMGR_TAPSMODE
    {
        BERTMGR_3TAPS = 0,
        BERTMGR_7TAPS = 1,
    };


    public enum BERTMGR_DSPMODE
    {
        BERTMGR_DSP_MODE_SLC1 = 0,                  // PAM4 Slicer
        BERTMGR_DSP_MODE_SLC1_LDEQ = 1,             // PAM4 Slicer + Level-dependent equalizer (LDEQ)
        BERTMGR_DSP_MODE_SLC1_RC_SLC2 = 2,          // PAM4 Slicer + Reflection canceller (RC)
        BERTMGR_DSP_MODE_SLC1_RC_LDEQ = 3,          // PAM4 Slicer + LDEQ + RC
        BERTMGR_DSP_MODE_DFE1 = 4,                  // Decision Feedback Equalizer (DFE)
        BERTMGR_DSP_MODE_DFE1_RC_DFE2 = 7,          // DFE + RC
        BERTMGR_DSP_MODE_SLC1_MPICAN_SLC2 = 8,      // PAM4 Slicer + Multipath interference canceller (MPICAN)
        BERTMGR_DSP_MODE_SLC1_MPICAN_LDEQ = 9,      // PAM4 Slicer + LDEQ + MPICAN
        BERTMGR_DSP_MODE_SLC1_RC_MPICAN_SLC2 = 10,  // PAM4 Slicer + RC + MPICAN
        BERTMGR_DSP_MODE_SLC1_RC_MPICAN_LDEQ = 11,  // PAM4 Slicer + LDEQ + RC + MPICAN
        BERTMGR_DSP_MODE_DFE1_MPICAN_DFE2 = 13,     // DFE + MPICAN
        BERTMGR_DSP_MODE_DFE1_RC_MPICAN_DFE2 = 15,  // DFE + RC + MPICAN
    };


    [StructLayout(LayoutKind.Sequential)]
    public struct AdvancedAmplitude
    {
        public int mainTap;
        public int postEmphasis;
        public int preEmphasis;
        public int innerLevel;
        public int outerLevel;
        public int scalingLevel;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I4, SizeConst = 7)]
        public int[] advancedTaps;
    };
    [StructLayout(LayoutKind.Sequential)]
    public struct FixedPatternDefinition
    {
        [MarshalAs(UnmanagedType.U8)]
        public ulong Pattern;
        [MarshalAs(UnmanagedType.U1)]
        public byte Repetition;
    };

    [StructLayout(LayoutKind.Sequential)]
    public struct UserDefinedPatternDefinition
    {
        public FixedPatternDefinition Pattern1;
        public FixedPatternDefinition Pattern2;
    };


    [StructLayout(LayoutKind.Sequential)]
    public struct NoiseSettings
    {
        [MarshalAs(UnmanagedType.R8)]
        public double NoiseLinerate;
        [MarshalAs(UnmanagedType.I1)]
        public bool NoiseStatus;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 8)]
        public bool[] NoiseChannelEnabled;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I4, SizeConst = 8)]
        public int[] NoiseLevel;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I4, SizeConst = 8)]
        public BERTMGR_PATTERNTYPE[] txPatternNoise;
        [MarshalAs(UnmanagedType.I4)]
        public BERTMGR_SIGMODULATION NoiseeyeMode;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
        public UserDefinedPatternDefinition[] NoiseUserDefinedPattern;
    };

    [StructLayout(LayoutKind.Sequential)]
    public struct AmpRange
    {
        [MarshalAs(UnmanagedType.I4)]
        public int min;                            // Minimum optimal amplitude value
        [MarshalAs(UnmanagedType.I4)]
        public int max;                            // Maximum optimal amplitude value
        [MarshalAs(UnmanagedType.I4)]
        public BERTMGR_CALIBRATIONMODE calMode;    // Calibration mode    
    };


    public enum BERTMGR_AFETRIM_OPT : int
    {
        BERTMGR_AFETRIM_NEG4DB = 0,
        BERTMGR_AFETRIM_NEG10DB = 1,
    };

    public enum SIGMODULATION
    {
        PAM4 = 0,
        NRZ = 1
    }

    public enum CLOCKSOURCE
    {
        EXTERNAL = 0,
        INTERNAL = 1
    }

    public enum CLOCKMODE
    {
        MONITORCLK_CH0toCH3,
        EXTERNAL,
        REFCLK,
        MONITORCLK_CH4toCH7,
        CDR,
        CDR_CH4toCH7,
        CleanCLK,
    }

    [Serializable]
    public enum FECMODE
    {
        FEC_DISABLED = -1,
        FEC_400G_KP8_TO_KP4 = 0,
        FEC_200G_KP4_TO_KP2 = 1,
        FEC_200G_KP4_TO_KP4 = 2,
        FEC_100G_KP2_TO_KP1 = 3,
        FEC_100G_KP4_TO_KP4 = 4,
        FEC_100G_KP4_TO_KP2 = 5,
        FEC_100G_PCS4_TO_KR1 = 6,
        FEC_50G_KP1_TO_KP1 = 7,
        FEC_50G_KP2_TO_KP2 = 8,
        FEC_50G_KR2_TO_KR1 = 9,
        FEC_25G_KR1_TO_KR1 = 10,
        FEC_25G_KP1_TO_KP1 = 11,
        FEC_50G_KS = 20,
        FEC_50G_KR = 21,
        FEC_50G_KP = 22,
        FEC_100G_KR = 23,
        FEC_100G_KP = 24,
        FEC_200G_KP = 25,
        FEC_400G_KP = 26,
        FEC_25G_FC = 40,
        FEC_25G_KR4 = 41,
        FEC_25G_KP4 = 42,
        FEC_50G_FC = 43,
        FEC_50G_KR4 = 44,
        FEC_50G_KP4 = 45,
        FEC_100G_FC = 46,
        FEC_100G_KR4 = 47,
        FEC_100G_KP4 = 48,
        FEC_200G_FC = 49,
        FEC_200G_KR4 = 50,
        FEC_200G_KP4 = 51
    }

    public enum FECPATTERN
    {
        FEC_Disabled = -1,
        FEC_Idle = 0,
        FEC_Local_Fault = 1,
        FEC_Remote_Fault = 2
    };

    public enum TAPSMODE
    {
        _3TAPS = 0,
        _7TAPS = 1,
        _11TAPS = 2,
        _21TAPS = 3,
    };

    [Serializable]
    public enum PATTERN
    {
        PRBS7 = 0,
        PRBS9_4 = 1,
        PRBS9_5 = 2,
        PRBS11 = 3,
        PRBS13 = 4,
        PRBS15 = 5,
        PRBS16 = 6,
        PRBS23 = 7,
        PRBS31 = 8,
        PRBS58 = 9,
        USERDEFINED = 10,
        JP083B = 11,
        LIN = 12,
        CJT = 13,
        SSPRQ = 14,
        SQ16 = 15,
        SQ32 = 16,
        IEEE8023BS_2 = 17,
        IEEE8023BS_4 = 18,
        OIFCEI31 = 19,
        AUTODETECT = 20,

    };

    public enum ERRORPATTERN
    {
        ERRINJ_PAT_BIT0 = 0,
        ERRINJ_PAT_BIT1 = 1,
        ERRINJ_PAT_BIT01 = 2,
        ERRINJ_PAT_MSBS = 3,
        ERRINJ_PAT_LSBS = 4,
        ERRINJ_PAT_ALL = 5,
        ERRINJ_PAT_WALK = 6,
        ERRINJ_PAT_WALK3 = 7,
    }

    public enum DSPMODE
    {
        POR_DSP_MODE_SLC1 = 0,
        POR_DSP_MODE_SLC1_LDEQ = 1,
        POR_DSP_MODE_SLC1_RC_SLC2 = 2,
        POR_DSP_MODE_SLC1_RC_LDEQ = 3,
        POR_DSP_MODE_DFE1 = 4,
        POR_DSP_MODE_DFE1_RC_DFE2 = 7,
        POR_DSP_MODE_SLC1_MPICAN_SLC2 = 8,
        POR_DSP_MODE_SLC1_MPICAN_LDEQ = 9,
        POR_DSP_MODE_SLC1_RC_MPICAN_SLC2 = 10,
        POR_DSP_MODE_SLC1_RC_MPICAN_LDEQ = 11,
        POR_DSP_MODE_DFE1_MPICAN_DFE2 = 13,
        POR_DSP_MODE_DFE1_RC_MPICAN_DFE2 = 15,
    };

    public enum AFETRIM_OPT
    {
        AFETRIM_NEG4DB = 0,
        AFETRIM_NEG10DB = 1,
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct ConfigurationSettings
    {
        // Parametes linerate configuration
        [MarshalAs(UnmanagedType.R8)]
        public double linerate;
        [MarshalAs(UnmanagedType.I4)]
        public SIGMODULATION eyemode;
        [MarshalAs(UnmanagedType.I1)]
        public bool grayMaping;
        [MarshalAs(UnmanagedType.I1)]
        public bool preCoding;
        [MarshalAs(UnmanagedType.I1)]
        public bool chipMode;
        [MarshalAs(UnmanagedType.I4)]
        public CLOCKSOURCE clockSource;
        [MarshalAs(UnmanagedType.I4)]
        public CLOCKMODE clockType;
        [MarshalAs(UnmanagedType.I4)]
        public int divider;
        [MarshalAs(UnmanagedType.I1)]
        public bool FEC;
        [MarshalAs(UnmanagedType.I4)]
        public FECMODE FECMode;
        [MarshalAs(UnmanagedType.I4)]
        public FECPATTERN FECPattern;
        [MarshalAs(UnmanagedType.I4)]
        public TAPSMODE TapsMode;
        [MarshalAs(UnmanagedType.I1)]
        public bool IEEEMode;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 7)]
        public bool[] allTaps;

        // Parameters for PRBS pattern configuration
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I4, SizeConst = 16)]
        public PATTERN[] txPattern;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I4, SizeConst = 16)]
        public PATTERN[] rxPattern;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] txInvert;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] rxInvert;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] txEnable;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] rxEnable;

        //  Parameters for each channel
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I4, SizeConst = 16)]
        public int[] amplitude;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public AdvancedAmplitude[] advancedAmplitude;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public AmpRange[] amplitudeRange;

        // Parameters for error insertion
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I4, SizeConst = 16)]
        public ERRORPATTERN[] errorModes;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public byte[] duration;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public byte[] gap;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 16)]
        public bool[] errorState;

        //Parameter for DSP mode
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I4, SizeConst = 16)]
        public DSPMODE[] DSPmode;

        //  Calibration validation status
        [MarshalAs(UnmanagedType.I1)]
        public bool calIsValid;

        // Channel's noise settings
        public NoiseSettings NoiseSettings;

        [MarshalAs(UnmanagedType.I1)]
        public bool ShallowLoopback;
        [MarshalAs(UnmanagedType.U2)]
        public ushort FECLinks;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public UserDefinedPatternDefinition[] UserDefinedPattern;

        [MarshalAs(UnmanagedType.I4)]
        public AFETRIM_OPT AFE_Trim;
        [MarshalAs(UnmanagedType.I1)]
        public bool FECAvailability;

        [MarshalAs(UnmanagedType.I4)]
        public int vegaDivider;
        [MarshalAs(UnmanagedType.I4)]
        public int CDRDivider;
        [MarshalAs(UnmanagedType.I4)]
        public int CDRSource;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I4, SizeConst = 16)]
        public int[] CTLE;

        [MarshalAs(UnmanagedType.I1)]
        public bool PMEnabled;
        [MarshalAs(UnmanagedType.I1)]
        public bool PMRJEnabled;
        [MarshalAs(UnmanagedType.U2)]
        public ushort PMAmplitude;
        [MarshalAs(UnmanagedType.U8)]
        public ulong PMFrequency;
        [MarshalAs(UnmanagedType.U2)]
        public ushort PMRJAmplitude;
        [MarshalAs(UnmanagedType.U2)]
        public ushort PMShifter;
        [MarshalAs(UnmanagedType.U2)]
        public ushort PRBSAmplitude;
        [MarshalAs(UnmanagedType.U2)]
        public ushort PMSwing;
        [MarshalAs(UnmanagedType.U2)]
        public ushort PMPattern;

        [MarshalAs(UnmanagedType.I1)]
        public bool FMEnabled;
        [MarshalAs(UnmanagedType.I1)]
        public bool FMRJEnabled;
        [MarshalAs(UnmanagedType.U2)]
        public ushort FMAmplitude;
        [MarshalAs(UnmanagedType.U8)]
        public ulong FMFrequency;
        [MarshalAs(UnmanagedType.U2)]
        public ushort FMRJAmplitude;
        [MarshalAs(UnmanagedType.U2)]
        public ushort FMShifter;
        [MarshalAs(UnmanagedType.I1)]
        public bool FixedEQ;
        [MarshalAs(UnmanagedType.I1)]
        public bool JTOLavailibility;
        [MarshalAs(UnmanagedType.I1)]
        public bool isExternal100;
        [MarshalAs(UnmanagedType.I1)]
        public bool PCIEavailibility;
    };

    [StructLayout(LayoutKind.Sequential)]
    public struct InstanceParams
    {
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 256)]
        public string saveConfig;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 256)]
        public string saveBathtub;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 256)]
        public string saveEye;
        [MarshalAs(UnmanagedType.I4)]
        public int saveBathtubEnable;
        [MarshalAs(UnmanagedType.I4)]
        public int saveEyeEnable;


    };
    [StructLayout(LayoutKind.Sequential)]
    public struct HistogramData
    {
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U4, SizeConst = 160)]
        public uint[] values;
    };

    //for ml4054
    public enum ADAPTER_TYPE
    {
        ADAPTER_TYPE_UNDETECTED = -1,
        ADAPTER_TYPE_NOADAPTER = 0,
        ADAPTER_TYPE_QDD = 1,
        ADAPTER_TYPE_OSFP = 2,
        ADAPTER_TYPE_QSFP = 3,
        ADAPTER_TYPE_SFP = 4,
        ADAPTER_TYPE_CFP2 = 5,
        ADAPTER_TYPE_SFP_DD = 6,
    };
    public enum ADAPTER_HWSIGNAL_CNTRL
    {
        ADAPTER_HWSIGNAL_CNTRL_QDD_MODSEL_L,
        ADAPTER_HWSIGNAL_CNTRL_QDD_RESET_L,
        ADAPTER_HWSIGNAL_CNTRL_QDD_INITMODE,
        ADAPTER_HWSIGNAL_CNTRL_QSFP_MODSEL_L,
        ADAPTER_HWSIGNAL_CNTRL_QSFP_RESET_L,
        ADAPTER_HWSIGNAL_CNTRL_QSFP_LPMODE,
        ADAPTER_HWSIGNAL_CNTRL_OSFP_LPWn,
        ADAPTER_HWSIGNAL_CNTRL_OSFP_RSTn,
    };
    public enum ADAPTER_EXTERNALMODE
    {
        ADAPTER_EXTERNALMODE_DISABLED,
        ADAPTER_EXTERNALMODE_HW_ENABLED,
        ADAPTER_EXTERNALMODE_SW_ENABLED,
    };
    public enum TXVR_RX_AMPLITUDE
    {
        TXVR_RX_AMPLITUDE_100_400 = 0,
        TXVR_RX_AMPLITUDE_300_600 = 1,
        TXVR_RX_AMPLITUDE_400_800 = 2,
        TXVR_RX_AMPLITUDE_600_1200 = 3,
        TXVR_RX_AMPLITUDE_RESERVED = 4,
        TXVR_RX_AMPLITUDE_CUSTOM = 15,
    };
    public enum TXVR_MSA_PAGE
    {
        TXVR_MSA_PAGE_LOWERMEMORY = 0,
        TXVR_MSA_PAGE_0 = 0,
        TXVR_MSA_PAGE_1 = 1,
        TXVR_MSA_PAGE_2 = 2,
        TXVR_MSA_PAGE_3 = 3,
        TXVR_MSA_PAGE_16 = 16,
        TXVR_MSA_PAGE_17 = 17,
    };

    [StructLayout(LayoutKind.Sequential)]
    public struct TXVR_ConfigurationSettings
    {
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 8)]
        public bool[] DataPathDeInit;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 8)]
        public bool[] TXOuputDisable;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 8)]
        public bool[] TXPolarityFlip;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 8)]
        public bool[] TXSquelchDisable;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 8)]
        public bool[] TXForceSquelch;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U1, SizeConst = 8)]
        public byte[] TXEqualization;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 8)]
        public bool[] RXOutputDisable;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 8)]
        public bool[] RXPolarityFlip;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I1, SizeConst = 8)]
        public bool[] RXSquelchDisable;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.I4, SizeConst = 8)]
        public TXVR_RX_AMPLITUDE[] RXOutputAmplitude;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U1, SizeConst = 8)]
        public byte[] RXOutputPreCursor;
        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.U1, SizeConst = 8)]
        public byte[] RXOutputPostCursor;
    };

    /// <summary>
    /// Modulation frenquency in kHz
    /// </summary>
    public enum BERTMGR_MODULATION_FREQ
    {
        BERTMGR_MOD_FREQ_40,
        BERTMGR_MOD_FREQ_100,
        BERTMGR_MOD_FREQ_1000,
        BERTMGR_MOD_FREQ_2500,
        BERTMGR_MOD_FREQ_4000,
        BERTMGR_MOD_FREQ_1500,
        BERTMGR_MOD_FREQ_10000,
        BERTMGR_MOD_FREQ_15000,
        BERTMGR_MOD_FREQ_20000,
        BERTMGR_MOD_FREQ_400,
    }



    #endregion

    public class mlbertmgr
    {
        public const string DLLPATH = "BertAcquisitionManagerLib.dll";

        public string rootPath;
        public object syncLock;
        public const int MAXCHANNELS = 8;
        public const int BERMAXITEMSPOP = 1024;
        public const int FECMAXNUMLINKS = 8;
        public const int SERMAXNUMSYMBOLS = 31;
        public const int MAX_ADDR_LEN = 256;
        #region Constructor 
        private IntPtr instance;
        public mlbertmgr()
        {
            syncLock = new object();
            instance = api_createInstance();

        }
        ~mlbertmgr() { }
        #endregion


        #region DLL Import

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_createInstance", CallingConvention = CallingConvention.Cdecl)]
        private static extern IntPtr api_createInstance();

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_destroyInstance", CallingConvention = CallingConvention.Cdecl)]
        private static extern void api_destroyInstance(IntPtr instance);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_openConnection", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_openConnection(IntPtr instance, string address);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_initializeInstance", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_initializeInstance(IntPtr instance, InstanceParams m_params);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_closeConnection", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_closeConnection(IntPtr instance);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_getActiveConfig", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_getActiveConfig(IntPtr instance, ref ConfigurationSettings initConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_applyConfiguration", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_applyConfiguration(IntPtr instance);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setLinerate", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setLinerate(IntPtr instance, ref double linerate, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setTxPattern", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setTxPattern(IntPtr instance, int channel, PatternConfig txPattern, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setRxPattern", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setRxPattern(IntPtr instance, int channel, PatternConfig txPattern, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setEyeMode", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setEyeMode(IntPtr instance, BERTMGR_SIGMODULATION eyeMode, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setClockSource", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setClockSource(IntPtr instance, BERTMGR_CLOCKSOURCE clockSource, bool applyConfig);

        //[DllImport(DLLPATH, EntryPoint = "mlbertmgr_commitConfig", CallingConvention = CallingConvention.Cdecl)]
        //[return: MarshalAs(UnmanagedType.I4)]
        //private static extern BERTMGR_STATUS api_commitConfig(IntPtr instance);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setClockMode", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setClockMode(IntPtr instance, BERTMGR_CLOCKMODE clockMode, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setMonitorDivider", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setMonitorDivider(IntPtr instance, BERTMGR_MONITORDIVIDER divider, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_getClockOut", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_getClockOut(IntPtr instance, ref double clockOutRate);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setAmplitude", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setAmplitude(IntPtr instance, int channel, int amplitude, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_getInfo", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_getInfo(IntPtr instance, ref Board_Info info);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setMainTap", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setMainTap(IntPtr instance, int channel, int mainTap, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setPostEmphasis", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setPostEmphasis(IntPtr instance, int channel, int postEmphasis, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setPreEmphasis", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setPreEmphasis(IntPtr instance, int channel, int preEmphasis, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setInnerEyeLevel", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setInnerEyeLevel(IntPtr instance, int channel, int innerLevel, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setOuterEyeLevel", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setOuterEyeLevel(IntPtr instance, int channel, int outerLevel, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setScalingLevel", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setScalingLevel(IntPtr instance, int channel, int scalingLevel, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setAdvancedAmplitude", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setAdvancedAmplitude(IntPtr instance, int channel, AdvancedAmplitude advAmplitude, ref int output, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setGrayCoding", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setGrayCoding(IntPtr instance, bool enable, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setFECMode", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setFECMode(IntPtr instance, BERTMGR_FECMODE mode, BERTMGR_FECPATTERN fecpattern, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_getGrayCoding", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_getGrayCoding(IntPtr instance, ref bool isEnabled);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_enableMonitor", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_enableMonitor(IntPtr instance, int enabledFlagsValue);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_enableMonitorFlag", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_enableMonitorFlag(IntPtr instance, BERTMGR_MONITOR_FLAGS flag, bool isEnabled);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_singleReadMonitor", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_singleReadMonitor(IntPtr instance, BERTMGR_MONITOR_FLAGS flag, ushort[] value);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_multiReadMonitor", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_multiReadMonitor(IntPtr instance, int enabledFlagsValue, ushort[] values);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_readLOS", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_readLOS(IntPtr instance, ref ushort value);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_startBERCaptureLoop", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_startBERCaptureLoop(IntPtr instance, ushort channels, bool accumulate = true);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_startBER", CallingConvention = CallingConvention.Cdecl)]
        private static extern void api_startBER(IntPtr instance, ushort channels, bool accumulate);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_GetAvailableBERData", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern int api_getAvailableBERData(IntPtr instance, [Out] MeasurementsData[] data);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_stopBER", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_stopBER(IntPtr instance);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_RxEnable", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_RxEnable(IntPtr instance, int channel, bool status);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_getRxStatus", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_getRxStatus(IntPtr instance, int channel, ref bool isEnabled);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_TxEnable", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_TxEnable(IntPtr instance, int channel, bool status);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_getTxStatus", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_getTxStatus(IntPtr instance, int channel, ref bool isEnabled);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setErrorRate", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setErrorRate(IntPtr instance, int channel, double rate, ref double actualrate, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setErrorPattern", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setErrorPattern(IntPtr instance, int channel, ErrorStruct error, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_stopErrorInsertion", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_stopErrorInsertion(IntPtr instance, int channel, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_getTxEmulationTapsFromLossAtNyquist", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_getTxEmulationTapsFromLossAtNyquist(IntPtr instance, ref int[] taps, double lossDb);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_getTxEmulationTapsFromSParams", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_getTxEmulationTapsFromSParams(IntPtr instance, ref int[] taps, char[] s2pFilePath);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_saveCalibrationValues", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_saveCalibrationValues(IntPtr instance, int channel, int mode, ref double Data, int lenData, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_saveOptimalSettings", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_saveOptimalSettings(IntPtr instance, int channel, int mode, ref int Data, int lenData, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_loadCalibrationValues", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_loadCalibrationValues(IntPtr instance, int channel, int mode, ref double Data, ref int lenData, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_loadOptimalSettings", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_loadOptimalSettings(IntPtr instance, int channel, int mode, ref int Data, ref int lenData, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setTapsMode", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setTapsMode(IntPtr instance, BERTMGR_TAPSMODE mode, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_writeAddress", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_writeAddress(IntPtr instance, int address, ushort[] data, int length);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setDSPMode", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setDSPMode(IntPtr instance, int channel, BERTMGR_DSPMODE DSPmode, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_getHistogramData", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_getHistogramData(IntPtr instance, ushort enabledChannels, [Out]HistogramData[] output);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_captureHistogramData", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_captureHistogramData(IntPtr instance, ushort enabledChannels, ref ushort actualEnabled);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_readHistogramData", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_readHistogramData(IntPtr instance, int channel, ref HistogramData output);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setActiveConfig", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setActiveConfig(IntPtr instance, ConfigurationSettings initConfig, bool forceUpdate);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_readFWOptions", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_readFWOptions(IntPtr instance, ref ulong options, bool forceUpdate);

  
        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_ConfigureFECLinks", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_configureFECLinks(IntPtr instance, ushort channels, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setUserDefinedPattern", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setUserDefinedPattern(IntPtr instance, int channel, UserDefinedPatternDefinition userDefinedPattern, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setAFETrim", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setAFETrim(IntPtr instance, BERTMGR_AFETRIM_OPT value, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setCDRDivider", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setCDRDivider(IntPtr instance, BERTMGR_CDRDIVIDER divider);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setCDRChannelSource", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setCDRChannelSource(IntPtr instance, int option);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setCTLE", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setCTLE(IntPtr instance, int channel, int CTLE, bool applyConfig);
        #endregion

        //additional fonction for the host
        #region dll import for ml4054
        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_detectAdapter", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_detectAdapter(IntPtr instance, ref ADAPTER_TYPE type);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setControlPin", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setControlPin(IntPtr instance, ADAPTER_HWSIGNAL_CNTRL cntrl, bool Status);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setExternalAdapterMode", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setExternalAdapterMode(IntPtr instance, bool isEnabled);

        [DllImport(DLLPATH, EntryPoint = "mltxvr_sequentialRead", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_sequentialRead(IntPtr instance, ushort pageSelect, ushort registerAddress, ushort dataLength, ushort[] dataBuffer, ushort bankSelect = 0);

        [DllImport(DLLPATH, EntryPoint = "mltxvr_sequentialWrite", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_sequentialWrite(IntPtr instance, ushort pageSelect, ushort registerAddress, ushort dataLength, ushort[] dataBuffer, ushort bankSelect = 0);

        [DllImport(DLLPATH, EntryPoint = "mltxvr_setTxOutputDisable", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setTxOutputDisable(IntPtr instance, int channel, bool Status);

        [DllImport(DLLPATH, EntryPoint = "mltxvr_setTxDataPathDeInit", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setTxDataPathDeInit(IntPtr instance, int channel, bool Status);

        [DllImport(DLLPATH, EntryPoint = "mltxvr_setTxForceSquelch", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setTxForceSquelch(IntPtr instance, int channel, bool Status);

        [DllImport(DLLPATH, EntryPoint = "mltxvr_setTxSquelchDisable", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setTxSquelchDisable(IntPtr instance, int channel, bool Status);

        [DllImport(DLLPATH, EntryPoint = "mltxvr_setTxPolarityFlip", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setTxPolarityFlip(IntPtr instance, int channel, bool Status);


        [DllImport(DLLPATH, EntryPoint = "mltxvr_setTxInputEqualization", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setTxInputEqualization(IntPtr instance, int channel, int value);

        [DllImport(DLLPATH, EntryPoint = "mltxvr_getActiveConfig", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_getActiveConfig(IntPtr instance, ref TXVR_ConfigurationSettings activeConfig);

        [DllImport(DLLPATH, EntryPoint = "mltxvr_setRxPolarityFlip", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setRxPolarityFlip(IntPtr instance, int channel, bool Status);

        [DllImport(DLLPATH, EntryPoint = "mltxvr_setRxSquelchDisable", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setRxSquelchDisable(IntPtr instance, int channel, bool Status);

        [DllImport(DLLPATH, EntryPoint = "mltxvr_setRxOutputDisable", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setRxOutputDisable(IntPtr instance, int channel, bool Status);

        [DllImport(DLLPATH, EntryPoint = "mltxvr_setRxPreCursor", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setRxPreCursor(IntPtr instance, int channel, int value);

        [DllImport(DLLPATH, EntryPoint = "mltxvr_setRxPostCursor", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setRxPostCursor(IntPtr instance, int channel, int value);

        [DllImport(DLLPATH, EntryPoint = "mltxvr_setRxAmplitude", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setRxAmplitude(IntPtr instance, int channel, TXVR_RX_AMPLITUDE value);

        [DllImport(DLLPATH, EntryPoint = "mltxvr_getMSAValues", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_getMSAValues(IntPtr instance, TXVR_MSA_PAGE[] pages, ushort[] Values, byte numberOfPages);




        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setNoiseLinerate", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setNoiseLinerate(IntPtr instance, ref double linerate, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_enableNoise", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_enableNoise(IntPtr instance, int channel, bool enable);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setNoiseLevel", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setNoiseLevel(IntPtr instance, int channel, int NoiseLevel, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setNoiseTxPattern", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setNoiseTxPattern(IntPtr instance, int channel, PatternConfig txPattern);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setShallowLoopback", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setShallowLoopback(IntPtr instance, bool enable, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setNoiseStatus", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setNoiseStatus(IntPtr instance, bool enable);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setNoiseBurstRate", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setNoiseBurstRate(IntPtr instance, int channel, double burstRate, ref double actualrate);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_enablePMSJ", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_enablePMSJ(IntPtr inst, bool enable, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setPMFrequency", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setPMFrequency(IntPtr inst, ushort frequency, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_enablePMRJ", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_enablePMRJ(IntPtr inst, bool enable, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setPMRJAmplitude", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setPMRJAmplitude(IntPtr inst, ushort amplitude, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setPMPhaseShift", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setPMPhaseShift(IntPtr inst, ushort shift, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setPMBUJAmplitude", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setPMBUJAmplitude(IntPtr inst, ushort amplitude, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setPMSJAmplitude_ps", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setPMSJAmplitude_ps(IntPtr inst, int amplitude, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_enableFMSJ", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_enableFMSJ(IntPtr inst, bool enable, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setFMFrequency", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setFMFrequency(IntPtr inst, ushort frequency, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_enableFMRJ", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_enableFMRJ(IntPtr inst, bool enable, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setFMRJAmplitude", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setFMRJAmplitude(IntPtr inst, ushort amplitude, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setFMPhaseShift", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setFMPhaseShift(IntPtr inst, ushort value, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setFMSJAmplitude_ps", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setFMSJAmplitude_ps(IntPtr inst, int value, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_setNoiseAmplitude_mV", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_setNoiseAmplitude_mV(IntPtr inst, int channel, int value, bool applyConfig);

        [DllImport(DLLPATH, EntryPoint = "mlbertmgr_getCDRLock", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I4)]
        private static extern BERTMGR_STATUS api_getCDRLock(IntPtr inst, int channel, ref bool lockOutput);


        #endregion

        #region functions
        public void mlbertmgr_destroyInstance()
        {

            lock (syncLock)
            {
                api_destroyInstance(instance);
            }
        }
        public void ResetInstance()
        {

            lock (syncLock)
            {
                api_destroyInstance(instance);
                instance = api_createInstance();
            }
        }
        public BERTMGR_STATUS mlbertmgr_openConnection(string address)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_openConnection(instance, address);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't connect to: " + address);
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_initializeInstance(InstanceParams m_params)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_initializeInstance(instance, m_params);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't initialize Instance ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_closeConnection()
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_closeConnection(instance);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't close Connection ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_getActiveConfig(ref ConfigurationSettings initConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_getActiveConfig(instance, ref initConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't get Active Config ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_applyConfiguration()
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_applyConfiguration(instance);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't apply Configuration");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setLinerate(double linerate, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setLinerate(instance, ref linerate, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set line rate");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setTxPattern(int channel, PatternConfig txPattern, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setTxPattern(instance, channel, txPattern, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set Tx pattern ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setRxPattern(int channel, PatternConfig txPattern, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setRxPattern(instance, channel, txPattern, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set Rx Pattern");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setEyeMode(BERTMGR_SIGMODULATION eyeMode, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setEyeMode(instance, eyeMode, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set Eye Mode");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setClockSource(BERTMGR_CLOCKSOURCE clockSource, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setClockSource(instance, clockSource, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't  set Clock Source");
            }
            return success;
        }
        //public BERTMGR_STATUS mlbertmgr_commitConfig()
        //{
        //    BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
        //    lock (syncLock)
        //    {
        //        success = api_commitConfig(instance);
        //    }
        //    if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
        //    {
        //        throw new Exception("can't commit Config");
        //    }
        //    return success;
        //}
        public BERTMGR_STATUS mlbertmgr_setClockMode(BERTMGR_CLOCKMODE clockMode, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setClockMode(instance, clockMode, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set  clock mode");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setMonitorDivider(BERTMGR_MONITORDIVIDER divider, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setMonitorDivider(instance, divider, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set  monitor devider");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_getClockOut(ref double clockOutRate)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_getClockOut(instance, ref clockOutRate);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't get  Clock out");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setAmplitude(int channel, int amplitude, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setAmplitude(instance, channel, amplitude, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't  set amplitude ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_getInfo(ref Board_Info info)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_getInfo(instance, ref info);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't  get board info");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setMainTap(int channel, int mainTap, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setMainTap(instance, channel, mainTap, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set  main tap");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setPostEmphasis(int channel, int postEmphasis, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setPostEmphasis(instance, channel, postEmphasis, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set  Post Emphasis ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setPreEmphasis(int channel, int preEmphasis, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setPreEmphasis(instance, channel, preEmphasis, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set Source");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setInnerEyeLevel(int channel, int innerLevel, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setInnerEyeLevel(instance, channel, innerLevel, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't setinner eye level ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setOuterEyeLevel(int channel, int outerLevel, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setOuterEyeLevel(instance, channel, outerLevel, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set out eye level ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setScalingLevel(int channel, int scalingLevel, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setScalingLevel(instance, channel, scalingLevel, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set scaling level");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setAdvancedAmplitude(int channel, AdvancedAmplitude advAmplitude, ref int output, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setAdvancedAmplitude(instance, channel, advAmplitude, ref output, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set advanced amplitude ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setGrayCoding(bool enable, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setGrayCoding(instance, enable, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set gray coding ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setFECMode(BERTMGR_FECMODE mode, BERTMGR_FECPATTERN pattern, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setFECMode(instance, mode, pattern, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set FEC mode");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_getGrayCoding(ref bool isEnabled)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_getGrayCoding(instance, ref isEnabled);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't get gray coding ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_enableMonitor(int enabledFlagsValue)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_enableMonitor(instance, enabledFlagsValue);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't enable monitor ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_enableMonitorFlag(BERTMGR_MONITOR_FLAGS flag, bool isEnabled)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_enableMonitorFlag(instance, flag, isEnabled);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't enable monitor flag ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_singleReadMonitor(BERTMGR_MONITOR_FLAGS flag, ushort[] value)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_singleReadMonitor(instance, flag, value);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't single read monitor ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_multiReadMonitor(int enabledFlagsValue, ushort[] values)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_multiReadMonitor(instance, enabledFlagsValue, values);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't multi read monitor ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_readLOS(ref ushort value)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_readLOS(instance, ref value);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't read LOS ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_startBERCaptureLoop(ushort channels, bool accumulate = true)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_startBERCaptureLoop(instance, channels, accumulate = true);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't start ber capture loop ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_startBER(ushort channels, bool accumulate)
        {
            lock (syncLock)
            {
                api_startBER(instance, channels, accumulate);
                return BERTMGR_STATUS.BERTMGR_SUCCESS;
            }
        }
        public int mlbertmgr_getAvailableBERData(ref MeasurementsData[] data)
        {
            int ct = 0;
            lock (syncLock)
            {
                ct = api_getAvailableBERData(instance, data);
            }         
            return ct;
        }
        public BERTMGR_STATUS mlbertmgr_stopBER()
        {
            lock (syncLock)
            {
                return api_stopBER(instance);
            }
        }
        public BERTMGR_STATUS mlbertmgr_RxEnable(int channel, bool status)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_RxEnable(instance, channel, status);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't enable Rx ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_getRxStatus(int channel, ref bool isEnabled)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_getRxStatus(instance, channel, ref isEnabled);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't get Rx status ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_TxEnable(int channel, bool status)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_TxEnable(instance, channel, status);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't enable Rx ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_getTxStatus(int channel, ref bool isEnabled)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_getTxStatus(instance, channel, ref isEnabled);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't get Rx status ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setErrorRate(int channel, double rate, ref double actualrate, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setErrorRate(instance, channel, rate, ref actualrate, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set error rate ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setErrorPattern(int channel, ErrorStruct error, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setErrorPattern(instance, channel, error, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set error pattern ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_stopErrorInsertion(int channel, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_stopErrorInsertion(instance, channel, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't stop error insertion ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_getTxEmulationTapsFromLossAtNyquist(int[] taps, double lossDb)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_getTxEmulationTapsFromLossAtNyquist(instance, ref taps, lossDb);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't get Tx Emulation Taps From Loss At Nyquist");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_getTxEmulationTapsFromSParams(ref int[] taps, char[] s2pFilePath)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_getTxEmulationTapsFromSParams(instance, ref taps, s2pFilePath);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't get Tx Emulation Taps From SParams");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_saveCalibrationValues(int channel, int mode, ref double Data, int lenData, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_saveCalibrationValues(instance, channel, mode, ref Data, lenData, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Save Calibration Values");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_saveOptimalSettings(int channel, int mode, ref int Data, int lenData, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_saveOptimalSettings(instance, channel, mode, ref Data, lenData, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Save Optimal Settings");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_loadCalibrationValues(int channel, int mode, ref double Data, ref int lenData, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_loadCalibrationValues(instance, channel, mode, ref Data, ref lenData, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Load Calibration Values");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_loadOptimalSettings(int channel, int mode, ref int Data, ref int lenData, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_loadOptimalSettings(instance, channel, mode, ref Data, ref lenData, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Load Optimal Settings ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setTapsMode(BERTMGR_TAPSMODE mode, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setTapsMode(instance, mode, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set taps mode");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_writeAddress(int address, ushort[] data, int length)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_writeAddress(instance, address, data, length);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Write Address");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setDSPMode(int channel, BERTMGR_DSPMODE DSPmode, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setDSPMode(instance, channel, DSPmode, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set DSP Mode");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_getHistogramData(ushort enabledChannels, HistogramData[] output)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_getHistogramData(instance, enabledChannels, output);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't get Histogram Data");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_captureHistogramData(ushort enabledChannels, ref ushort actualEnabled)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_captureHistogramData(instance, enabledChannels, ref actualEnabled);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Capture Histogram Data");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_readHistogramData(int channel, ref HistogramData output)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_readHistogramData(instance, channel, ref output);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Read Histogram Data");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setActiveConfig(ConfigurationSettings initConfig, bool forceUpdate)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setActiveConfig(instance, initConfig, forceUpdate);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set Active Config");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_readFWOptions(ref ulong options, bool forceUpdate)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_readFWOptions(instance, ref options, forceUpdate);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Read FW Options");
            }
            return success;
        }
      
        public BERTMGR_STATUS mlbertmgr_configureFECLinks(ushort channels, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_configureFECLinks(instance, channels, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Configure FEC Links ");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setUserDefinedPattern(int channel, UserDefinedPatternDefinition userDefinedPattern, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setUserDefinedPattern(instance, channel, userDefinedPattern, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set User Defined Pattern");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setAFETrim(BERTMGR_AFETRIM_OPT value, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setAFETrim(instance, value, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set AFE Trim");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setCDRDivider(BERTMGR_CDRDIVIDER divider)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setCDRDivider(instance, divider);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set CDR Divider");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setCDRChannelSource(int option)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setCDRChannelSource(instance, option);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set CDR Channel Source");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setCTLE(int channel, int CTLE, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setCTLE(instance, channel, CTLE, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set CTLE");
            }
            return success;
        }




        #region Noise Function

        public BERTMGR_STATUS mlbertmgr_setNoiseLinerate(ref double linerate, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setNoiseLinerate(instance, ref linerate, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set Noise Linerate");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_enableNoise(int channel, bool enable)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_enableNoise(instance, channel, enable);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Enable Noise");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setNoiseLevel(int channel, int NoiseLevel, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setNoiseLevel(instance, channel, NoiseLevel, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set Noise Level");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setNoiseTxPattern(int channel, PatternConfig txPattern)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setNoiseTxPattern(instance, channel, txPattern);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set Noise Tx Pattern");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setShallowLoopback(bool enable, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setShallowLoopback(instance, enable, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set Shallow Loop back");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setNoiseStatus(bool enable)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setNoiseStatus(instance, enable);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set Noise Status");
            }
            return success;
        }
        public BERTMGR_STATUS mlbertmgr_setNoiseBurstRate(int channel, double burstRate, ref double actualrate)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setNoiseBurstRate(instance, channel, burstRate, ref actualrate);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set Noise Burst Rate");
            }
            return success;
        }

        public BERTMGR_STATUS mlbertmgr_setNoiseAmplitude_mV(int channel, int value, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setNoiseAmplitude_mV(instance, channel, value, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set Noise Amplitude mV");
            }
            return success;
        }

        public BERTMGR_STATUS mlbertmgr_enablePMSJ(bool enable, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_enablePMSJ(instance, enable, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't enable PMSJ");
            }
            return success;
        }

        public BERTMGR_STATUS mlbertmgr_setPMFrequency(ushort frequency, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED; 
            lock (syncLock)
            {
                success = api_setPMFrequency(instance, frequency, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
                {
                throw new Exception("can't set PM Frequency");
            }
            return success;
        }

        public BERTMGR_STATUS mlbertmgr_enablePMRJ(bool enable, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_enablePMRJ(instance, enable, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't enable PM RJ");
            }
            return success;
        }

        public BERTMGR_STATUS mlbertmgr_setPMRJAmplitude(ushort amplitude, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setPMRJAmplitude(instance, amplitude, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set PM RJ Amplitude");
            }
            return success;
        }

        public BERTMGR_STATUS mlbertmgr_setPMPhaseShift(ushort amplitude, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setPMPhaseShift(instance, amplitude, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set PM Phase Shift");
            }
            return success;
        }

        public BERTMGR_STATUS mlbertmgr_setPMBUJAmplitude(ushort amplitude, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setPMBUJAmplitude(instance, amplitude, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("set PM BUJ Amplitude");
            }
            return success;
        }

        public BERTMGR_STATUS mlbertmgr_setPMSJAmplitude_ps(int value, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setPMSJAmplitude_ps(instance, value, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set PM SJ Amplitude ps");
            }
            return success;
        }

        public BERTMGR_STATUS mlbertmgr_enableFMSJ(bool enable, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_enableFMSJ(instance, enable, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't enable FM SJ");
            }
            return success;
        }

        public BERTMGR_STATUS mlbertmgr_setFMFrequency(ushort frequency, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setFMFrequency(instance, frequency, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set FM Frequency");
            }
           return success;
        }

        public BERTMGR_STATUS mlbertmgr_enableFMRJ(bool enable, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_enableFMRJ(instance, enable, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't enable FM RJ");
            }
            return success;
        }

        public BERTMGR_STATUS mlbertmgr_setFMRJAmplitude(ushort amplitude, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setFMRJAmplitude(instance, amplitude, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set FM RJ Amplitude");
            }
            return success;
        }

        public BERTMGR_STATUS mlbertmgr_setFMPhaseShift(ushort amplitude, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setFMPhaseShift(instance, amplitude, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set FM Phase Shift");
            }
            return success;
        }

        public BERTMGR_STATUS mlbertmgr_setFMSJAmplitude_ps(int value, bool applyConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setFMSJAmplitude_ps(instance,value, applyConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't set FM SJ Amplitude ps");
            }
            return success;
        }

        public BERTMGR_STATUS mlbertmgr_getCDRLock(int value, ref bool lockOutput)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_getCDRLock(instance, value, ref lockOutput);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't get CDR Lock status");
            }
            return success;
        }

        #endregion
        #endregion
       
        #region ml4054


       

        public BERTMGR_STATUS mlbertmgr_detectAdapter(ref ADAPTER_TYPE type)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_detectAdapter(instance, ref type);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Detect Adapter");
            }
            return success;
        }




        public BERTMGR_STATUS mlbertmgr_setControlPin(ADAPTER_HWSIGNAL_CNTRL cntrl, bool Status)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setControlPin(instance, cntrl, Status);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Set Control Pin");
            }
            return success;
        }

        public BERTMGR_STATUS mlbertmgr_setExternalAdapterMode(bool isEnabled)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setExternalAdapterMode(instance, isEnabled);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Set External Adapter Mode");
            }
            return success;
        }



        public BERTMGR_STATUS mltxvr_sequentialRead(ushort pageSelect, ushort registerAddress, ushort dataLength,ref ushort[] dataBuffer, ushort bankSelect = 0)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_sequentialRead(instance, pageSelect, registerAddress, dataLength, dataBuffer, bankSelect = 0);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Sequential Read");
            }
            return success;
        }

        public BERTMGR_STATUS mltxvr_sequentialWrite(ushort pageSelect, ushort registerAddress, ushort dataLength, ushort[] dataBuffer, ushort bankSelect = 0)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_sequentialWrite(instance, pageSelect, registerAddress, dataLength, dataBuffer, bankSelect = 0);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Sequential Write");
            }
            return success;
        }




        public BERTMGR_STATUS mltxvr_setTxOutputDisable(int channel, bool Status)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setTxOutputDisable(instance, channel, Status);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Set TX Output Disable");
            }
            return success;
        }

        public BERTMGR_STATUS mltxvr_setTxDataPathDeInit(int channel, bool Status)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setTxDataPathDeInit(instance, channel, Status);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Set TX Data PathDeInit");
            }
            return success;
        }

        public BERTMGR_STATUS mltxvr_setTxForceSquelch(int channel, bool Status)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setTxForceSquelch(instance, channel, Status);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Set TX Force Squelch");
            }
            return success;
        }

        public BERTMGR_STATUS mltxvr_setTxSquelchDisable(int channel, bool Status)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setTxSquelchDisable(instance, channel, Status);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Set TX Squelch Disable");
            }
            return success;
        }


        public BERTMGR_STATUS mltxvr_setTxPolarityFlip(int channel, bool Status)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setTxPolarityFlip(instance, channel, Status);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Set TX Polarity Flip");
            }
            return success;
        }


        public BERTMGR_STATUS mltxvr_setTxInputEqualization(int channel, int value)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setTxInputEqualization(instance, channel, value);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Set TX Input Equalization");
            }
            return success;
        }

        public BERTMGR_STATUS mltxvr_getActiveConfig(ref TXVR_ConfigurationSettings activeConfig)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_getActiveConfig(instance, ref activeConfig);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Get Active Config");
            }
            return success;
        }

        public BERTMGR_STATUS mltxvr_setRxPolarityFlip(int channel, bool Status)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setRxPolarityFlip(instance, channel, Status);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Set RX Polarity Flip");
            }
            return success;
        }

        public BERTMGR_STATUS mltxvr_setRxSquelchDisable(int channel, bool Status)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setRxSquelchDisable(instance, channel, Status);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Set RX Squel ch Disable");
            }
            return success;
        }

        public BERTMGR_STATUS mltxvr_setRxOutputDisable(int channel, bool Status)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setRxOutputDisable(instance, channel, Status);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Set RX Output Disable");
            }
            return success;
        }

        public BERTMGR_STATUS mltxvr_setRxPreCursor(int channel, int value)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setRxPreCursor(instance, channel, value);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Set RX Pre Cursor");
            }
            return success;
        }

        public BERTMGR_STATUS mltxvr_setRxPostCursor(int channel, int value)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setRxPostCursor(instance, channel, value);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Set RX Post Cursor");
            }
            return success;
        }

        public BERTMGR_STATUS mltxvr_setRxAmplitude(int channel, TXVR_RX_AMPLITUDE value)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_setRxAmplitude(instance, channel, value);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Set RX Amplitude");
            }
            return success;
        }


        public BERTMGR_STATUS mltxvr_getMSAValues(TXVR_MSA_PAGE[] pages, ref ushort[] Values, byte numberOfPages)
        {
            BERTMGR_STATUS success = BERTMGR_STATUS.BERTMGR_FAILED;
            lock (syncLock)
            {
                success = api_getMSAValues(instance, pages, Values, numberOfPages);
            }
            if (success != BERTMGR_STATUS.BERTMGR_SUCCESS)
            {
                throw new Exception("can't Get MSA Values");
            }
            return success;
        }
        #endregion


    }
}







